/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.config.net;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.HttpClientBuilder;

public class ProxyConfig {
    private final HttpHost host;

    public ProxyConfig(HttpHost host) {
        this.host = host;
    }

    public void apply(HttpClientBuilder httpClientBuilder) {
        if (this.host != null) {
            httpClientBuilder.setProxy(this.host);
        }
    }

    public static ProxyConfig parse(Map<String, Object> config, String property) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(config, validationErrors);
        if (config.get(property) instanceof String) {
            String simpleString = (String)config.get(property);
            try {
                return new ProxyConfig(HttpHost.create((String)simpleString));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigValidationException(new InvalidAttributeValue(property, (Object)"HTTP host URL", (Object)simpleString).cause(e));
            }
        }
        if (vNode.hasNonNull(property + ".host")) {
            String hostName = vNode.get(property + ".host").asString();
            int port = vNode.get(property + ".port").withDefault(80).allowingNumericStrings().asInt();
            String scheme = vNode.get(property + ".scheme").withDefault("https").asString();
            validationErrors.throwExceptionForPresentErrors();
            return new ProxyConfig(new HttpHost(hostName, port, scheme));
        }
        return new ProxyConfig(null);
    }

    public static ProxyConfig parse(DocNode docNode) throws ConfigValidationException {
        if (docNode.toBasicObject() instanceof String) {
            String simpleString = (String)docNode.toBasicObject();
            try {
                return new ProxyConfig(HttpHost.create((String)simpleString));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)"HTTP host URL", (Object)simpleString).cause(e));
            }
        }
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
        String hostName = vNode.get("host").required().asString();
        int port = vNode.get("port").withDefault(80).allowingNumericStrings().asInt();
        String scheme = vNode.get("scheme").withDefault("https").asString();
        vNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        return new ProxyConfig(new HttpHost(hostName, port, scheme));
    }

    public HttpHost getHost() {
        return this.host;
    }

    public String toString() {
        return "ProxyConfig [host=" + this.host + "]";
    }
}

